*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file for Nids Wave 3

* THIS IS 7th INCOME DO FILE - RELEASE DO FILE: 7 OF 7
* THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

*=====================================================================================================================================

* OPENING DATASET CREATED IN DO FILE "Income - Aggregation of post-imputation variables (6 of 7)"

use "$DataOUT\hhdata.dta", clear

foreach var of varlist hhq_incb fwag cwag swag cheq prof extr bonu othe help  ///
ppen uif comp indi inhe rnt retr brid gift loan sale remt  {
rename `var'_data `var'_flg
}

keep pid w3_hhid hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag_imp cwag_imp swag_imp ///
cheq_imp prof_imp extr_imp bonu_imp othe_imp help_imp  spen ppen_imp uif comp_imp dis ///
chld fost cdep indi_imp inhe_imp rnt_imp retr_imp brid_imp gift_imp loan_imp sale_imp remt_imp fwag_flg ///
cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg ///
dis_flg chld_flg fost_flg cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg ///
remt_flg 
sort w3_hhid

//note: dm83/rensfix.ado has to be installed for the rensfix command to work
//this is readily avaliable in stata help
rensfix _imp

*Renaming 
foreach x of varlist hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag cwag swag ///
cheq prof extr bonu othe help  spen ppen uif comp dis chld fost cdep indi inhe ///
rnt retr brid gift loan sale remt fwag_flg cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg ///
othe_flg help_flg  spen_flg ppen_flg uif_flg comp_flg dis_flg chld_flg fost_flg ///
cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg remt_flg {
rename `x' w3_`x'
}

save "$DataOUT\temp.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* HOUSEHOLD LEVEL RELEASE

use "$DataOUT\temp.dta", clear
keep w3_hhid w3_hhsizer w3_hhq_inc w3_hhq_incb w3_hhq_incb_flg w3_hhincome ///
w3_hhincome_flg w3_hhwage w3_hhgovt w3_hhother w3_hhinvest w3_hhcapital w3_hhremitt ///
w3_hhimprent w3_hhimprent_flg w3_hhagric w3_pi_hhincome w3_pi_hhwage w3_pi_hhgovt ///
w3_pi_hhother w3_pi_hhinvest w3_pi_hhcapital w3_pi_hhremitt  w3_pi_hhagric w3_pi_hhimprent
sort w3_hhid
drop if w3_hhid==w3_hhid[_n-1]

sort w3_hhid
save "$DataOUT\release.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* INDIVIDUAL LEVEL RELEASE

use "$DataOUT\temp.dta", clear

keep pid w3_hhid w3_fwag w3_cwag w3_swag w3_cheq w3_prof w3_extr w3_bonu w3_othe ///
w3_help  w3_spen w3_ppen w3_uif w3_comp w3_dis w3_chld w3_fost w3_cdep w3_indi w3_inhe ///
w3_rnt w3_retr w3_brid w3_gift w3_loan w3_sale w3_remt w3_fwag_flg w3_cwag_flg w3_swag_flg ///
w3_cheq_flg w3_prof_flg w3_extr_flg w3_bonu_flg w3_othe_flg w3_help_flg  w3_spen_flg ///
w3_ppen_flg w3_uif_flg w3_comp_flg w3_dis_flg w3_chld_flg w3_fost_flg w3_cdep_flg w3_indi_flg ///
w3_inhe_flg w3_rnt_flg w3_retr_flg w3_brid_flg w3_gift_flg w3_loan_flg w3_sale_flg w3_remt_flg

order pid w3_hhid w3_fwag w3_cwag w3_swag w3_cheq w3_prof w3_extr w3_bonu w3_othe w3_help  ///
w3_spen w3_ppen w3_uif w3_comp w3_dis w3_chld w3_fost w3_cdep w3_indi w3_inhe w3_rnt w3_retr ///
w3_brid w3_gift w3_loan w3_sale w3_remt w3_fwag_flg w3_cwag_flg w3_swag_flg w3_cheq_flg ///
w3_prof_flg w3_extr_flg w3_bonu_flg w3_othe_flg w3_help_flg  w3_spen_flg w3_ppen_flg ///
w3_uif_flg w3_comp_flg w3_dis_flg w3_chld_flg w3_fost_flg w3_cdep_flg w3_indi_flg w3_inhe_flg ///
w3_rnt_flg w3_retr_flg w3_brid_flg w3_gift_flg w3_loan_flg w3_sale_flg w3_remt_flg

lab var w3_fwag "Monthly take home pay from primary and secondary jobs"
lab var w3_cwag "Monthly take home pay from casual work"
lab var w3_swag "Monthly income from self-employment"
lab var w3_cheq "Income from 13th cheque"
lab var w3_prof "Income from profit share"
lab var w3_extr "Monthly income from extra payment on a piece-rate basis"
lab var w3_bonu "Income from other bonuses from main job"
lab var w3_othe "Monthly income from other sources"
lab var w3_help "Monthly income from helping friends"


lab var w3_ppen "Monthly income from private/foriegn penion pension and retirement annuities"
lab var w3_uif "Monthly income from UIF payments"
lab var w3_comp "Monthly income from workmen's compensation"
lab var w3_indi "Monthly income from interest and dividends"
lab var w3_inhe "Monthly income from inheritances"
lab var w3_rnt "Monthly income from rentals"
lab var w3_retr "Monthly income from retrenchment payments"
lab var w3_brid "Monthly income from lobola/bridal payments"
lab var w3_gift "Monthly income from gifts"
lab var w3_loan "Monthly 'income' from loan repayments"
lab var w3_sale "Monthly 'income' from sale of household assets"
lab var w3_remt "Monthly income from remittance payments"
lab var w3_fwag_flg "Net wage data flag"
lab var w3_cwag_flg "Casual wage data flag"
lab var w3_swag_flg "Self employment wage data flag"
lab var w3_cheq_flg "13th cheque data flag"
lab var w3_prof_flg "Profit share data flag"
lab var w3_extr_flg "Extra piece-rate payment data flag"
lab var w3_bonu_flg "Bonus income data flag"
lab var w3_othe_flg "Income from other sources data flag"
lab var w3_help_flg "Help income data flag"


lab var w3_ppen_flg "Private pension/retirement annuity data flag"
lab var w3_uif_flg "UIF income data flag"
lab var w3_comp_flg "Workmen's compensation data flag"
lab var w3_indi_flg "Interest and dividend income data flag"
lab var w3_inhe_flg "Inheritance income data flag"
lab var w3_rnt_flg "Rental income data flag"
lab var w3_retr_flg "Retrenchment income data flag"
lab var w3_brid_flg "Lobola/bridal income data flag"
lab var w3_gift_flg "Gift income data flag"
lab var w3_loan_flg "Loan repayment income data flag"
lab var w3_sale_flg "Sale of household assets data flag"
lab var w3_remt_flg "Remittance income data flag"

sort pid
save "$DataOUT\release_indiv.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* FINAL RELEASE FILES

clear
use "$DataOUT\temp.dta", clear

sort w3_hhid
merge m:1 w3_hhid using "$DataOUT\release.dta"
drop _merge
sort w3_hhid
drop if w3_hhid==w3_hhid[_n-1]
compress

keep w3_hhid w3_hhsizer w3_hhq_inc w3_hhq_incb w3_hhq_incb_flg w3_hhincome w3_hhincome_flg ///
w3_hhwage w3_hhgovt w3_hhother w3_hhinvest w3_hhcapital w3_hhremitt w3_hhimprent w3_hhimprent_flg ///
w3_pi_hhincome w3_pi_hhwage w3_pi_hhgovt w3_pi_hhother w3_pi_hhinvest w3_pi_hhcapital ///
w3_pi_hhremitt w3_pi_hhagric w3_hhagric w3_pi_hhimprent w3_hhagric

order w3_hhid  /*w3_hhprov w3_hhgeo w3_hhdc w3_hhcluster w3_wgt w3_dwgt w3_wgt_p1 w3_dwgt_p1 w3_dtwgt_p1*/ ///
/*w3_dtwgt*/ w3_hhsizer w3_hhq_inc w3_hhq_incb w3_hhq_incb_flg w3_hhincome w3_hhincome_flg ///
w3_hhwage w3_hhgovt w3_hhother w3_hhinvest w3_hhcapital w3_hhremitt w3_hhimprent w3_hhimprent_flg ///
w3_hhagric w3_pi_hhincome w3_pi_hhwage w3_pi_hhgovt w3_pi_hhother w3_pi_hhinvest w3_pi_hhcapital ///
w3_pi_hhremitt w3_pi_hhagric w3_pi_hhimprent

lab var w3_hhq_incb_flg "The household income as per household questionnaire data"
lab var w3_hhagric "Household average monthly income from subsistence agriculture"

compress
save "$DataOUT\hhderived_INCOME", replace
erase "$DataOUT\temp.dta"

*Individual derived

use "$DataOUT\release_indiv.dta", clear
order pid w3_hhid
compress
duplicates drop pid, force
save "$DataOUT\indderived_INCOME", replace


erase "$DataOUT\data.dta"
capture erase "$DataOUT\temp.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\hhdata.dta"
erase "$DataOUT\release.dta"
erase "$DataOUT\release_indiv.dta"

* end of do file
*==================================================================================================================================================
*check

